/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.client;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import net.jayjay.dangerzone.client.DZ2;
import org.lwjgl.opengl.Display;

public class DZ2Applet
extends Applet
implements Runnable {
    private static final long serialVersionUID = 6705214970663861190L;
    private Canvas display_parent;
    private Thread gameThread;
    private DZ2 game;
    private boolean running = false;
    private volatile boolean resizePending = false;
    private volatile int newWidth = 0;
    private volatile int newHeight = 0;

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        try {
            this.display_parent = new Canvas(){

                @Override
                public void addNotify() {
                    super.addNotify();
                    DZ2Applet.this.startLWJGL();
                }

                @Override
                public void removeNotify() {
                    DZ2Applet.this.stopLWJGL();
                    super.removeNotify();
                }
            };
            this.display_parent.setSize(this.getWidth(), this.getHeight());
            this.add((Component)this.display_parent, "Center");
            this.display_parent.setFocusable(true);
            this.display_parent.requestFocus();
            this.display_parent.setIgnoreRepaint(true);
            this.addComponentListener(new ComponentAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void componentResized(ComponentEvent e2) {
                    DZ2Applet dZ2Applet = DZ2Applet.this;
                    synchronized (dZ2Applet) {
                        DZ2Applet.this.newWidth = DZ2Applet.this.getWidth();
                        DZ2Applet.this.newHeight = DZ2Applet.this.getHeight();
                        DZ2Applet.this.resizePending = true;
                    }
                }
            });
            this.setVisible(true);
        }
        catch (Exception e2) {
            System.err.println("Failed to create display: " + e2.getMessage());
            e2.printStackTrace();
            throw new RuntimeException("Unable to create display", e2);
        }
    }

    private void startLWJGL() {
        if (this.running) {
            System.out.println("already running!");
            return;
        }
        this.running = true;
        this.gameThread = new Thread((Runnable)this, "DangerZone-Applet");
        this.gameThread.start();
    }

    private void stopLWJGL() {
        this.running = false;
        try {
            if (this.gameThread != null) {
                this.gameThread.join();
            }
        }
        catch (InterruptedException e2) {
            System.err.println("Error stopping LWJGL: " + e2.getMessage());
            e2.printStackTrace();
        }
    }

    @Override
    public void start() {
        if (!this.running) {
            this.startLWJGL();
        }
    }

    @Override
    public void stop() {
        if (this.running) {
            this.stopLWJGL();
        }
    }

    @Override
    public void destroy() {
        if (this.running) {
            this.stopLWJGL();
        }
        this.remove(this.display_parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            this.game = new DZ2();
            this.game.canvas = this.display_parent;
            this.game.randomTitleText();
            Display.setParent(this.display_parent);
            this.game.init();
            if (true) ** GOTO lbl42
        }
        catch (Exception e) {
            System.err.println("Failed to initialize game: " + e.getMessage());
            e.printStackTrace();
            this.running = false;
            return;
        }
        do {
            try {
                if (this.resizePending) {
                    e = this;
                    synchronized (e) {
                        this.display_parent.setSize(this.newWidth, this.newHeight);
                        this.game.width = this.newWidth;
                        this.game.height = this.newHeight;
                        this.game.updateViewport();
                        this.resizePending = false;
                    }
                }
                if (Display.wasResized()) {
                    this.game.updateViewport();
                }
                this.game.timer.advanceTime();
                i = 0;
                while (i < this.game.timer.ticks) {
                    this.game.tick();
                    ++i;
                }
                this.game.render(this.game.timer.a);
                Display.update();
            }
            catch (Exception e) {
                System.err.println("Error in game loop: " + e.getMessage());
                e.printStackTrace();
                this.running = false;
            }
lbl42:
            // 3 sources

        } while (this.running && this.display_parent.isDisplayable());
        try {
            this.game.destroy();
        }
        catch (Exception e) {
            System.err.println("Error during cleanup: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void update(Graphics g2) {
        this.paint(g2);
    }

    @Override
    public void paint(Graphics g2) {
    }
}

